/*
 * MPDT_Msg_Parsers.h
 *
 *  Created on: Mar 29, 2019
 *      Author: gjd5kor
 */

#ifndef APPL_UTIL_JSON_PARSERS_MPDT_MSG_PARSERS_H_
#define APPL_UTIL_JSON_PARSERS_MPDT_MSG_PARSERS_H_


#include "fc_mcan_tcu_AppMain.h"
#include "json_utils.h"
#include "fc_mcan_tcu_ClassTypes.h"

class MPDT_Msg_Parsers
{

private:
	json_utils oParseUtil;

	tBool bParseAndFillTimeLimitRestriction(Json::Value &oData,TCU_Time_Limit_Restriction &oTCU_Time_Limit_Restriction);
	tBool bParseAndFillTimeSlot(Json::Value &oData,TCU_Time_Slot &oTCU_Time_Slot);
	tBool bParseAndFillDateTime(Json::Value &oData,TCU_Date_Time &oTCU_Date_Time);
	tBool bGetDataFromFile(Json::Value &oData,std::string sFilePath);
	tBool bParseAndFillSpeedLimitRestriction(Json::Value &oData,TCU_Speed_Limit_Restriction &oTCU_Speed_Limit_Restriction);
	tBool bParseAndFillAreaLimitRestriction(Json::Value &oData,TCU_Area_Limit_Restriction &oTCU_Area_Limit_Restriction);
	tBool bParseAndFillAreaCoordinate(Json::Value &oData,Area_Coorinate &oArea_Coorinate);
	tBool bParseAndFillCordinate(Json::Value &oData,TCU_GPS_Position &oCordinates, std::string sCordStr);
	tBool bParseAndFillNaviVehicleSpeed(Json::Value& oData, Navi_Vehicle_Speed& oNavi_Vehicle_Speed);
	tBool bParseAndFillNaviDrivingDistance(Json::Value& oData, Navi_Driving_Distance& oNavi_Driving_Distance);
	tBool bParseAndFillNaviRoadClassification(Json::Value& oData, Navi_Road_Classification& oNavi_Road_Classification);
	tBool bParseAndFillLocationInfo(Json::Value& oData, TCU_Location_Info& oCordinates, std::string sCordStr);
	tBool bParseAndFillAltitude(Json::Value& oData, Altitude& oCordinates, std::string sCordStr);






public:
	MPDT_Msg_Parsers();
	virtual ~MPDT_Msg_Parsers();

	tBool bParseAndFillRestrictionSettings(Restriction_Settings &oRestrictionSettings);
	tBool bParseAndFillTCUState(TCUState& oTCUState);
	tBool bParseAndFillTCUExtendedStateStatus(TCUExtendedState& oTCUExtendedState);
	tBool bParseAndFillTCUExtendedStateIndication(TCUExtendedState& oTCUExtendedState);
	tBool bParseAndFillProbevehicleInfo(Probe_Vehicle_Info& oProbe_Vehicle_Info);
	tBool bParseAndFillNaviInfo(Navi_Info& oNavi_Info);
	tBool bParseAndFillAreaLimitIndication(Area_Limit &oArea_Limit);
	tBool bParseAndFillTimeLimitIndication(Time_Limit &oTime_Limit);
	tBool bParseAndFillSpeedLimitIndication(Speed_Limit &oSpeed_Limit);



};

#endif /* APPL_UTIL_JSON_PARSERS_MPDT_MSG_PARSERS_H_ */
